#! /usr/bin/env python3

import unittest
import numpy

import ogonek



class TestGlove(unittest.TestCase):
  
  def test_load(self):
    glove = ogonek.Glove()
    self.assertTrue(len(glove)==29632)
  
  
  def test_words(self):
    glove = ogonek.Glove()
    arr = glove.decode('and')
    self.assertTrue(arr.shape[0]==300)
    self.assertFalse(numpy.allclose(arr, numpy.zeros(300)))
    
    arr = glove.decode('does not exist')
    self.assertTrue(numpy.allclose(arr, numpy.zeros(300)))



if __name__ == '__main__':
    unittest.main()
